/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty.items;

import com.djinfinite.manors_bounty.configuration.FruitsEffectConfig;
import com.djinfinite.manors_bounty.utils.Utils;
import com.djinfinite.manors_bounty.utils.data_struct.Quintuple;
import com.djinfinite.manors_bounty.utils.data_struct.Sextuplet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.apache.commons.lang3.tuple.Triple;

public abstract class FoodEffect {
    private FoodEffect() {
    }

    public static boolean addEffectLevel(LivingEntity livingEntity, MobEffect effect, int levelToAdd, int limit) {
        MobEffectInstance entityEffect = livingEntity.m_21124_(effect);
        if (entityEffect != null) {
            int lvl = Math.min(entityEffect.m_19564_() + levelToAdd, limit - 1);
            livingEntity.m_7292_(new MobEffectInstance(effect, entityEffect.m_19557_(), lvl));
            return true;
        }
        return false;
    }

    public static boolean addEffectTime(LivingEntity livingEntity, MobEffect effect, int ticksToAdd) {
        MobEffectInstance entityEffect = livingEntity.m_21124_(effect);
        if (entityEffect != null) {
            livingEntity.m_7292_(new MobEffectInstance(effect, entityEffect.m_19557_() + ticksToAdd, entityEffect.m_19564_()));
            return true;
        }
        return false;
    }

    public static boolean addEffectTimePercent(LivingEntity livingEntity, MobEffect effect, float percent) {
        MobEffectInstance entityEffect = livingEntity.m_21124_(effect);
        if (entityEffect != null) {
            livingEntity.m_7292_(new MobEffectInstance(effect, Math.round((float)entityEffect.m_19557_() * (1.0f + percent)), entityEffect.m_19564_()));
            return true;
        }
        return false;
    }

    public abstract boolean apply(LivingEntity var1);

    public static abstract class X
    extends FoodEffect {
        protected final ArrayList<Function<LivingEntity, Boolean>> consumers = new ArrayList();
        protected final ArrayList<Component> tooltip = new ArrayList();

        public List<Function<LivingEntity, Boolean>> consumers() {
            return this.consumers;
        }

        public void addTooltip(Component component) {
            this.tooltip.add(component);
        }

        public ArrayList<Component> tooltip() {
            return this.tooltip;
        }

        public static class XC
        extends X {
            private final C c;

            private XC(C c) {
                this.c = c;
            }

            public static XC of(C c) {
                return new XC(c);
            }

            public XC addConsumer(Function<LivingEntity, Boolean> function) {
                this.consumers.add(function);
                return this;
            }

            @Override
            public boolean apply(LivingEntity livingEntity) {
                if (!Utils.fruitEffectEnabled()) {
                    return false;
                }
                boolean shouldCooldownF = false;
                boolean shouldCooldownC = this.c.apply(livingEntity);
                for (Function function : this.consumers) {
                    shouldCooldownF = (Boolean)function.apply(livingEntity);
                }
                return shouldCooldownC || shouldCooldownF;
            }

            public C c() {
                return this.c;
            }
        }

        public static class XB
        extends X {
            private final B b;

            private XB(B b) {
                this.b = b;
            }

            public static XB of(B b) {
                return new XB(b);
            }

            public XB addConsumer(Function<LivingEntity, Boolean> function) {
                this.consumers.add(function);
                return this;
            }

            @Override
            public boolean apply(LivingEntity livingEntity) {
                if (!Utils.fruitEffectEnabled()) {
                    return false;
                }
                boolean shouldCooldownF = false;
                boolean shouldCooldownB = this.b.apply(livingEntity);
                for (Function function : this.consumers) {
                    shouldCooldownF = (Boolean)function.apply(livingEntity);
                }
                return shouldCooldownB || shouldCooldownF;
            }

            public B b() {
                return this.b;
            }
        }
    }

    public static final class C
    extends FoodEffect {
        private final List<Quintuple<MobEffect, Double, Double, Integer, Integer>> mobEffects = new ArrayList<Quintuple<MobEffect, Double, Double, Integer, Integer>>();
        Integer newTime = (Integer)FruitsEffectConfig.FOODS_NEW_TIME_C.get() * 20;

        private C() {
        }

        public static C of() {
            return new C();
        }

        public C addEffect(MobEffect effect) {
            return this.addEffect(effect, 90.0, 15.0, 1, this.newTime);
        }

        public C addEffect(MobEffect effect, double firstChance, double secondChance, int addLevel, int newTime) {
            this.mobEffects.add(Quintuple.of(effect, firstChance, secondChance, addLevel, newTime));
            return this;
        }

        @Override
        public boolean apply(LivingEntity livingEntity) {
            if (!Utils.fruitEffectEnabled()) {
                return false;
            }
            double first = this.mobEffects.stream().mapToDouble(Quintuple::getSecond).max().orElse(90.0);
            double second = this.mobEffects.stream().mapToDouble(Quintuple::getThird).max().orElse(10.0);
            if (Utils.chanceToTrigger(first)) {
                MobEffectInstance entityEffect;
                int newTime;
                int addLevel;
                MobEffect effect;
                for (Quintuple<MobEffect, Double, Double, Integer, Integer> quintuple : this.mobEffects) {
                    effect = quintuple.getFirst();
                    addLevel = quintuple.getFourth();
                    newTime = quintuple.getFifth();
                    entityEffect = livingEntity.m_21124_(effect);
                    if (entityEffect != null) {
                        C.addEffectLevel(livingEntity, effect, addLevel, 8);
                        continue;
                    }
                    livingEntity.m_7292_(new MobEffectInstance(effect, newTime, 0));
                }
                if (Utils.chanceToTrigger(second)) {
                    for (Quintuple<MobEffect, Double, Double, Integer, Integer> quintuple : this.mobEffects) {
                        effect = quintuple.getFirst();
                        addLevel = quintuple.getFourth();
                        newTime = quintuple.getFifth();
                        entityEffect = livingEntity.m_21124_(effect);
                        if (entityEffect != null) {
                            C.addEffectLevel(livingEntity, effect, addLevel, 8);
                            continue;
                        }
                        livingEntity.m_7292_(new MobEffectInstance(effect, newTime, 0));
                    }
                }
            }
            return true;
        }

        public List<Quintuple<MobEffect, Double, Double, Integer, Integer>> mobEffects() {
            return this.mobEffects;
        }
    }

    public static final class B
    extends FoodEffect {
        private final ArrayList<Sextuplet<MobEffect, Double, Integer, Integer, Integer, Integer>> mobEffects = new ArrayList();
        int firstAddTime = (Integer)FruitsEffectConfig.FOODS_ADD_TIME_B.get() * 20;
        int secondAddTime = (Integer)FruitsEffectConfig.FOODS_ADD_TIME_B.get() * 20;
        int newTime = (Integer)FruitsEffectConfig.FOODS_NEW_TIME_B.get() * 20;

        private B() {
        }

        public static B of() {
            return new B();
        }

        public B addEffect(MobEffect effect, double firstChance) {
            this.mobEffects.add(Sextuplet.of(effect, firstChance, this.firstAddTime, 1, this.secondAddTime, this.newTime));
            return this;
        }

        public B addEffect(MobEffect effect, double firstChance, int firstAddTime, int addLevel, int secondAddTime, int newTime) {
            this.mobEffects.add(Sextuplet.of(effect, firstChance, firstAddTime, addLevel, secondAddTime, newTime));
            return this;
        }

        @Override
        public boolean apply(LivingEntity livingEntity) {
            if (!Utils.fruitEffectEnabled()) {
                return false;
            }
            boolean shouldCooldown = false;
            double max = this.mobEffects.stream().mapToDouble(Sextuplet::getSecond).max().orElse(70.0);
            if (Utils.chanceToTrigger(max)) {
                for (Sextuplet<MobEffect, Double, Integer, Integer, Integer, Integer> sextuplet : this.mobEffects) {
                    MobEffect effect = sextuplet.getFirst();
                    if (!B.addEffectTime(livingEntity, effect, sextuplet.getThird())) continue;
                    shouldCooldown = true;
                }
            } else {
                for (Sextuplet<MobEffect, Double, Integer, Integer, Integer, Integer> sextuplet : this.mobEffects) {
                    MobEffect effect = sextuplet.getFirst();
                    MobEffectInstance entityEffect = livingEntity.m_21124_(effect);
                    if (entityEffect != null) {
                        B.addEffectLevel(livingEntity, effect, sextuplet.getFourth(), 6);
                        B.addEffectTime(livingEntity, effect, sextuplet.getFifth());
                        continue;
                    }
                    livingEntity.m_7292_(new MobEffectInstance(effect, sextuplet.getSixth().intValue(), 0));
                }
                shouldCooldown = true;
            }
            return shouldCooldown;
        }

        public List<Sextuplet<MobEffect, Double, Integer, Integer, Integer, Integer>> mobEffects() {
            return this.mobEffects;
        }
    }

    public static final class A
    extends FoodEffect {
        private final ArrayList<Triple<MobEffect, Double, Integer>> mobEffects = new ArrayList();

        private A() {
        }

        public static A of() {
            return new A();
        }

        public A addEffect(MobEffect effect) {
            return this.addEffect(effect, 100.0, 1);
        }

        public A addEffect(MobEffect effect, double chance) {
            return this.addEffect(effect, chance, 1);
        }

        public A addEffect(MobEffect effect, double chance, int level) {
            this.mobEffects.add((Triple<MobEffect, Double, Integer>)Triple.of((Object)effect, (Object)chance, (Object)level));
            return this;
        }

        @Override
        public boolean apply(LivingEntity livingEntity) {
            if (!Utils.fruitEffectEnabled()) {
                return false;
            }
            boolean shouldCooldown = false;
            double chance = this.mobEffects.stream().mapToDouble(Triple::getMiddle).min().orElse(1.0);
            if (Utils.chanceToTrigger(chance)) {
                for (Triple<MobEffect, Double, Integer> triple : this.mobEffects) {
                    MobEffect effect = (MobEffect)triple.getLeft();
                    MobEffectInstance entityEffect = livingEntity.m_21124_(effect);
                    if (entityEffect == null) continue;
                    A.addEffectLevel(livingEntity, effect, (Integer)triple.getRight(), 4);
                    shouldCooldown = true;
                }
            }
            return shouldCooldown;
        }

        public List<Triple<MobEffect, Double, Integer>> mobEffects() {
            return this.mobEffects;
        }
    }
}

